/*
WEST

Standing dead tree net stock change, both live ag and bg carbon density and also volumes
from query of FIADB 

Estimates are an informal approximation of change in standing dead trees based on stock at time1 and time2
The code generates two tables accoding to stand classifications -- by typegroup versus softwood/hardwood/woodland
The resulting .csv table (e.g., standdNetchange_07Nov2022.csv)
  returned from oracle is the union tables and is exactly as it appears in the model

Column names are explained in the model, but briefly:
- columns 1-4 classify the forest stand
- NETCHANGE_STANDDCAG_TPAPY: net annual change in standing dead aboveground carbon, tons C/acre/year
- NETCHANGE_STANDDCAG_TPAPY: net annual change in standing dead belowground carbon, tons C/acre/year
- the remaining columns are standing stock at times 1 and 2
4 01 groups 
   
See the FIADB database documentaion for additional informaion on data and methods  
https://www.fia.fs.usda.gov/library/database-documentation/index.php#FIADB 


NOTE NOTE: queries for the full 48 never seem to work
so this (and another) are split to east-west
then the two tables are pooled


05Oct2023, from 09Dec2022 jes 
*/



SELECT 
 
  /*num.statecd,  */  /* statecd, GRPstatecd,  */
  num.conusRegion,
  num.possibleTypes,   /* possibleTypes,  GRP2,   */
  /*num.harvDstrb,  */ /*   harvDstrb,  GRPdistrb, */
  num.standOrigin, 
  num.ageBin,  /* ageBin,  GRP1, */
 
  (num.time1_standdag+num.time2_standdag) / den.ESTIMATE netchange_standdCag_tpapy, 
  (num.time1_standdbg+num.time2_standdbg) / den.ESTIMATE netchange_standdCbg_tpapy, 
  
  num.time1_standdag / den.ESTIMATE time1_standdCag_tpapy,  
  num.time2_standdag / den.ESTIMATE time2_standdCag_tpapy, 
 
  num.time1_standdbg / den.ESTIMATE time1_standdCbg_tpapy,  
  num.time2_standdbg / den.ESTIMATE time2_standdCbg_tpapy, 
    
  den.ESTIMATE DEN_ESTIMATED_ac


  
FROM 
  (
    SELECT 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
   coalesce(possibleTypes,'Unknown') as possibleTypes,
    coalesce(standOrigin, 'Unknown') as standOrigin,
    coalesce(ageBin, 'Unknown') as ageBin,
   
   sum(time1_standd_ag * EXPNS) time1_standdag ,
   sum(time2_standd_ag * EXPNS) time2_standdag ,
   sum(time1_standd_bg * EXPNS) time1_standdbg ,
   sum(time2_standd_bg * EXPNS) time2_standdbg 
 
    FROM 
      (
	   select
 
              case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end as agebin,
				  
      
      -- FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd) as possibleTypes, 
      /*
      case when refft.typgrpcd in (180,970) then 'predominantly woodland species, type not known'
		    when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)'
			when refft.typgrpcd <400 then 'predominantly softwood species, type not known'
            else 'predominantly hardwood species, type not known' end as 	possibleTypes,	
		*/	
      	refftgrp.meaning 	as 	possibleTypes,
		
      case when cond.stdorgcd=1 then 'Planted'
		else 'Natural' end as standOrigin,
		           
      -- to_char(cond.statecd)  statecd, 

      /*case 
      when cond.trtcd1=10 or cond.trtcd2=10 or cond.trtcd3=10 then 'harv/distrb' 
      when cond.dstrbcd1 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd2 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd3 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
            else 'without h/d'
      end  harvDstrb,*/

       case when cond.statecd in(9,10,11,23,24,25,33,34,36,42,44,50,54) then 'Northeast'
            when cond.statecd in(17,18,19,29,39) then 'Central States'
            when cond.statecd in(20,31,38,46) then 'Great Plains'
            when cond.statecd in(26,27,55) then 'Northern Lake States'
            when ( cond.statecd in(40,48) and cond.unitcd in(3,4,5,6,7) ) then 'Great Plains'
            when cond.statecd in(1,5,21,22,28,40,47,48)  then 'South Central'
            when cond.statecd in(12,13,37,45,51)  then 'Southeast'
            when cond.statecd in(16,30)  then 'Rocky Mountain North'
            when cond.statecd in(4,8,32,35,49,56)  then 'Rocky Mountain South'
            when cond.statecd in(6)  then 'Pacific Southwest'
            when ( cond.statecd in(41,53) and cond.unitcd in(0,1,2,5,6,7) ) then 'Pacific Northwest Westside'
            when ( cond.statecd in(41,53) and cond.unitcd in(3,4,8,9) ) then 'Pacific Northwest Eastside'
            else 'not located' end as conusRegion ,

          pop_stratum.expns EXPNS, 
		  
	  
		   -- standd at t1 
         SUM(pTREE.TPA_UNADJ * 
		      CASE WHEN pTREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(pTREE.DIA, 5 - 0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(pTREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when ptree.statuscd=2 and  ptree.standing_dead_cd=1  then COALESCE(-pTREE.carbon_ag / 2000 / plot.remper, 0) else 0 end
          ) AS time1_standd_ag ,
	
	     -- standd at t2
        SUM(TREE.TPA_UNADJ * 
		      CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(TREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when tree.statuscd=2 and  tree.standing_dead_cd=1  then COALESCE(TREE.carbon_ag / 2000 / plot.remper, 0) else 0 end
          ) AS time2_standd_ag ,

  
		   -- bg standd at t1 
         SUM(pTREE.TPA_UNADJ * 
		      CASE WHEN pTREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(pTREE.DIA, 5 - 0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(pTREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when ptree.statuscd=2 and  ptree.standing_dead_cd=1  then COALESCE(-pTREE.carbon_bg / 2000 / plot.remper, 0) else 0 end
          ) AS time1_standd_bg ,
	
	     -- bg standd at t2
        SUM(TREE.TPA_UNADJ * 
		      CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(TREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when tree.statuscd=2 and  tree.standing_dead_cd=1  then COALESCE(TREE.carbon_bg / 2000 / plot.remper, 0) else 0 end
          ) AS time2_standd_bg 





         FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN ) 
		  join (select  unique  plt_cn, condid, prev_plt_cn, prevcond, SUBPTYP
               from  FS_FIADB.SUBP_COND_CHNG_MTRX ) sccm on (sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN)
          JOIN FS_FIADB.PLOT PLOT ON ( POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN   ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
		  JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
 	  
      JOIN FS_FIADB.TREE ON (
            TREE.PLT_CN = COND.PLT_CN 
            AND TREE.CONDID = COND.CONDID )
      JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
      JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
	   	   
	    --  so cuz outer will match these if it can but include the ptrees anyway if unmatched...
	   full OUTER JOIN FS_FIADB.TREE PTREE ON  
		     ( PTREE.PLT_CN = pCOND.PLT_CN  and ptree.CONDID = pCOND.CONDID  and  PTREE.cn = tree.prev_tre_cn  )
		
      
        WHERE 
		         --TREE.STATUSCD = 1 
		  sccm.condid = COND.CONDID 
          AND sccm.plt_cn = COND.PLT_CN 
          AND PCOND.CONDID = sccm.prevcond 
          AND PCOND.PLT_CN = sccm.prev_plt_cn 
		  
           and ( (COND.PROP_BASIS != 'MACR' and  sccm.SUBPTYP = 1 ) or
		        (COND.PROP_BASIS='MACR' and  sccm.SUBPTYP = 3 ) ) 
		  
		  and COND.CONDPROP_UNADJ  = pCOND.CONDPROP_UNADJ 
          and COND.COND_STATUS_CD = 1 
		  and pCOND.COND_STATUS_CD = 1 
 		  AND COND.CONDPROP_UNADJ IS NOT NULL 
 		  
		  
 		  --and pop_stratum.evalid in (331901)
      /* conus44 and the 4 split states */
	  
   AND (
     		( pop_stratum.evalid in (161901,301901,41901,81901,321901,351901,491901,561801)) -- RMN RMS 		
           or  
			( pop_stratum.evalid in (61901,411901,531901 ))  -- PWW PWE PSW  		
        /*    or  
			( pop_stratum.evalid in (92101,102101,232101,242101,252001,332101,342001,
                                     362001,422101,442001,502101,542101 ))  -- NE		
            or  
			( pop_stratum.evalid in (172101,182101,192101,292101,392101,262101,272101,552101,
                                     121901,132101,372201,452101,512101  ))  -- CS SE NLS	
            or  
		   ( pop_stratum.evalid in (202001,312101,382101,462101,12201,52101,211901,221901,282101,471901))  -- GP & SC		
            or			  
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
        */  ) 

        
      
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
              case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end ,

          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd),
      cond.stdorgcd,cond.statecd,cond.unitcd,cond.trtcd1,cond.trtcd2,cond.trtcd3,refftgrp.meaning ,
                             cond.dstrbcd1,cond.dstrbcd2,cond.dstrbcd3 , refft.typgrpcd
      ) 
    GROUP BY 
    /*statecd,*/
   conusRegion, cube(possibleTypes,standOrigin,ageBin)
	/*harvDstrb,*/
    --possibleTypes,
    --standOrigin,
    --ageBin
    
    ORDER BY 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
    possibleTypes,
    standOrigin,
    ageBin

  ) num 
  
  
  
  join (
    SELECT 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
    coalesce(possibleTypes,'Unknown') as possibleTypes,
    coalesce(standOrigin, 'Unknown') as standOrigin,
    coalesce(ageBin, 'Unknown') as ageBin,
      sum(ESTIMATED_VALUE * EXPNS) ESTIMATE 
    FROM 
      (
        SELECT 
 
              case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end as agebin,
				  
      
      -- FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd) as possibleTypes, 
      /*
      case when refft.typgrpcd in (180,970) then 'predominantly woodland species, type not known'
		    when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)'
			when refft.typgrpcd <400 then 'predominantly softwood species, type not known'
            else 'predominantly hardwood species, type not known' end as 	possibleTypes,	
		*/	
      	refftgrp.meaning 	as 	possibleTypes,
		
      case when cond.stdorgcd=1 then 'Planted'
		else 'Natural' end as standOrigin,
		           
      -- to_char(cond.statecd)  statecd, 

      /*case 
      when cond.trtcd1=10 or cond.trtcd2=10 or cond.trtcd3=10 then 'harv/distrb' 
      when cond.dstrbcd1 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd2 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd3 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
            else 'without h/d'
      end  harvDstrb,*/

       case when cond.statecd in(9,10,11,23,24,25,33,34,36,42,44,50,54) then 'Northeast'
            when cond.statecd in(17,18,19,29,39) then 'Central States'
            when cond.statecd in(20,31,38,46) then 'Great Plains'
            when cond.statecd in(26,27,55) then 'Northern Lake States'
            when ( cond.statecd in(40,48) and cond.unitcd in(3,4,5,6,7) ) then 'Great Plains'
            when cond.statecd in(1,5,21,22,28,40,47,48)  then 'South Central'
            when cond.statecd in(12,13,37,45,51)  then 'Southeast'
            when cond.statecd in(16,30)  then 'Rocky Mountain North'
            when cond.statecd in(4,8,32,35,49,56)  then 'Rocky Mountain South'
            when cond.statecd in(6)  then 'Pacific Southwest'
            when ( cond.statecd in(41,53) and cond.unitcd in(0,1,2,5,6,7) ) then 'Pacific Northwest Westside'
            when ( cond.statecd in(41,53) and cond.unitcd in(3,4,8,9) ) then 'Pacific Northwest Eastside'
            else 'not located' end as conusRegion ,


        pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ESTIMATED_VALUE 
		  
         FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN ) 
		  join (select  unique  plt_cn, condid, prev_plt_cn, prevcond, SUBPTYP
               from  FS_FIADB.SUBP_COND_CHNG_MTRX ) sccm on (sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN)
          JOIN FS_FIADB.PLOT PLOT ON ( POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN   ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
		  JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
 	  
        JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
      JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
	   	   
		
      
        WHERE 
		         --TREE.STATUSCD = 1 
		  sccm.condid = COND.CONDID 
          AND sccm.plt_cn = COND.PLT_CN 
          AND PCOND.CONDID = sccm.prevcond 
          AND PCOND.PLT_CN = sccm.prev_plt_cn 
		  
           and ( (COND.PROP_BASIS != 'MACR' and  sccm.SUBPTYP = 1 ) or
		        (COND.PROP_BASIS='MACR' and  sccm.SUBPTYP = 3 ) ) 
		  
		  and COND.CONDPROP_UNADJ  = pCOND.CONDPROP_UNADJ 
          and COND.COND_STATUS_CD = 1 
		  and pCOND.COND_STATUS_CD = 1 
 		  AND COND.CONDPROP_UNADJ IS NOT NULL 

 		  
		  
 		  --and pop_stratum.evalid in (331901)
      /* conus44 and the 4 split states */
	  
    AND (
     		( pop_stratum.evalid in (161901,301901,41901,81901,321901,351901,491901,561801)) -- RMN RMS 		
           or  
			( pop_stratum.evalid in (61901,411901,531901 ))  -- PWW PWE PSW  		
        /*    or  
			( pop_stratum.evalid in (92101,102101,232101,242101,252001,332101,342001,
                                     362001,422101,442001,502101,542101 ))  -- NE		
            or  
			( pop_stratum.evalid in (172101,182101,192101,292101,392101,262101,272101,552101,
                                     121901,132101,372201,452101,512101  ))  -- CS SE NLS	
            or  
		   ( pop_stratum.evalid in (202001,312101,382101,462101,12201,52101,211901,221901,282101,471901))  -- GP & SC		
            or			  
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
        */  ) 

        
      
      
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
             case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end ,
          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd),
      cond.stdorgcd,cond.statecd,cond.unitcd,cond.trtcd1,cond.trtcd2,cond.trtcd3,refftgrp.meaning ,
                             cond.dstrbcd1,cond.dstrbcd2,cond.dstrbcd3 , refft.typgrpcd
      ) 
    GROUP BY 
    /*statecd,*/
   conusRegion, cube(possibleTypes,standOrigin,ageBin)
	/*harvDstrb,*/
    --possibleTypes,
    --standOrigin,
    --ageBin

    ORDER BY 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
    possibleTypes,
    standOrigin,
    ageBin

  ) den ON num.conusRegion = den.conusRegion 
  AND num.possibleTypes = den.possibleTypes
  AND num.standOrigin = den.standOrigin
  AND num.ageBin = den.ageBin
  /*AND num.conusRegion = den.conusRegion
  AND num.standOrigin = den.standOrigin*/






union





SELECT 
 
  /*num.statecd,  */  /* statecd, GRPstatecd,  */
  num.conusRegion,
  num.possibleTypes,   /* possibleTypes,  GRP2,   */
  /*num.harvDstrb,  */ /*   harvDstrb,  GRPdistrb, */
  num.standOrigin, 
  num.ageBin,  /* ageBin,  GRP1, */
 
  (num.time1_standdag+num.time2_standdag) / den.ESTIMATE netchange_standdCag_tpapy, 
  (num.time1_standdbg+num.time2_standdbg) / den.ESTIMATE netchange_standdCbg_tpapy, 
  
  num.time1_standdag / den.ESTIMATE time1_standdCag_tpapy,  
  num.time2_standdag / den.ESTIMATE time2_standdCag_tpapy, 
 
  num.time1_standdbg / den.ESTIMATE time1_standdCbg_tpapy,  
  num.time2_standdbg / den.ESTIMATE time2_standdCbg_tpapy, 
    
  den.ESTIMATE DEN_ESTIMATED_ac


  
FROM 
  (
    SELECT 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
   coalesce(possibleTypes,'Unknown') as possibleTypes,
    coalesce(standOrigin, 'Unknown') as standOrigin,
    coalesce(ageBin, 'Unknown') as ageBin,
   
   sum(time1_standd_ag * EXPNS) time1_standdag ,
   sum(time2_standd_ag * EXPNS) time2_standdag ,
   sum(time1_standd_bg * EXPNS) time1_standdbg ,
   sum(time2_standd_bg * EXPNS) time2_standdbg 
 
    FROM 
      (
        SELECT 
		
            case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end as agebin,
				  
      
      -- FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd) as possibleTypes, 
      
      case when refft.typgrpcd in (180,970) then 'predominantly woodland species, type not known'
		    when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)'
			when refft.typgrpcd <400 then 'predominantly softwood species, type not known'
            else 'predominantly hardwood species, type not known' end as 	possibleTypes,	
			
      	--refftgrp.meaning 	as 	possibleTypes,
		
      case when cond.stdorgcd=1 then 'Planted'
		else 'Natural' end as standOrigin,
		           
      -- to_char(cond.statecd)  statecd, 

      /*case 
      when cond.trtcd1=10 or cond.trtcd2=10 or cond.trtcd3=10 then 'harv/distrb' 
      when cond.dstrbcd1 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd2 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd3 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
            else 'without h/d'
      end  harvDstrb,*/

       case when cond.statecd in(9,10,11,23,24,25,33,34,36,42,44,50,54) then 'Northeast'
            when cond.statecd in(17,18,19,29,39) then 'Central States'
            when cond.statecd in(20,31,38,46) then 'Great Plains'
            when cond.statecd in(26,27,55) then 'Northern Lake States'
            when ( cond.statecd in(40,48) and cond.unitcd in(3,4,5,6,7) ) then 'Great Plains'
            when cond.statecd in(1,5,21,22,28,40,47,48)  then 'South Central'
            when cond.statecd in(12,13,37,45,51)  then 'Southeast'
            when cond.statecd in(16,30)  then 'Rocky Mountain North'
            when cond.statecd in(4,8,32,35,49,56)  then 'Rocky Mountain South'
            when cond.statecd in(6)  then 'Pacific Southwest'
            when ( cond.statecd in(41,53) and cond.unitcd in(0,1,2,5,6,7) ) then 'Pacific Northwest Westside'
            when ( cond.statecd in(41,53) and cond.unitcd in(3,4,8,9) ) then 'Pacific Northwest Eastside'
            else 'not located' end as conusRegion ,

          pop_stratum.expns EXPNS, 
		  
	  
		   -- standd at t1 
         SUM(pTREE.TPA_UNADJ * 
		      CASE WHEN pTREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(pTREE.DIA, 5 - 0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(pTREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when ptree.statuscd=2 and  ptree.standing_dead_cd=1  then COALESCE(-pTREE.carbon_ag / 2000 / plot.remper, 0) else 0 end
          ) AS time1_standd_ag ,
	
	     -- standd at t2
        SUM(TREE.TPA_UNADJ * 
		      CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(TREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when tree.statuscd=2 and  tree.standing_dead_cd=1  then COALESCE(TREE.carbon_ag / 2000 / plot.remper, 0) else 0 end
          ) AS time2_standd_ag ,

  
		   -- bg standd at t1 
         SUM(pTREE.TPA_UNADJ * 
		      CASE WHEN pTREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(pTREE.DIA, 5 - 0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(pTREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN pTREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when ptree.statuscd=2 and  ptree.standing_dead_cd=1  then COALESCE(-pTREE.carbon_bg / 2000 / plot.remper, 0) else 0 end
          ) AS time1_standd_bg ,
	
	     -- bg standd at t2
        SUM(TREE.TPA_UNADJ * 
		      CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP 
                   ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR 
                   ELSE CASE LEAST(TREE.DIA, COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END 
			  * case when tree.statuscd=2 and  tree.standing_dead_cd=1  then COALESCE(TREE.carbon_bg / 2000 / plot.remper, 0) else 0 end
          ) AS time2_standd_bg 


		  

         FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN ) 
		  join (select  unique  plt_cn, condid, prev_plt_cn, prevcond, SUBPTYP
               from  FS_FIADB.SUBP_COND_CHNG_MTRX ) sccm on (sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN)
          JOIN FS_FIADB.PLOT PLOT ON ( POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN   ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
		  JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
 	  
      JOIN FS_FIADB.TREE ON (
            TREE.PLT_CN = COND.PLT_CN 
            AND TREE.CONDID = COND.CONDID )
      JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
      JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
	   	   
	    --  so cuz outer will match these if it can but include the ptrees anyway if unmatched...
	   full OUTER JOIN FS_FIADB.TREE PTREE ON  
		     ( PTREE.PLT_CN = pCOND.PLT_CN  and ptree.CONDID = pCOND.CONDID  and  PTREE.cn = tree.prev_tre_cn  )
		
      
        WHERE 
		         --TREE.STATUSCD = 1 
		  sccm.condid = COND.CONDID 
          AND sccm.plt_cn = COND.PLT_CN 
          AND PCOND.CONDID = sccm.prevcond 
          AND PCOND.PLT_CN = sccm.prev_plt_cn 
		  
           and ( (COND.PROP_BASIS != 'MACR' and  sccm.SUBPTYP = 1 ) or
		        (COND.PROP_BASIS='MACR' and  sccm.SUBPTYP = 3 ) ) 
		  
		  and COND.CONDPROP_UNADJ  = pCOND.CONDPROP_UNADJ 
          and COND.COND_STATUS_CD = 1 
		  and pCOND.COND_STATUS_CD = 1 
 		  AND COND.CONDPROP_UNADJ IS NOT NULL 

 		  
		  
 		  --and pop_stratum.evalid in (331901)
      /* conus44 and the 4 split states */
	  
    AND (
     		( pop_stratum.evalid in (161901,301901,41901,81901,321901,351901,491901,561801)) -- RMN RMS 		
           or  
			( pop_stratum.evalid in (61901,411901,531901 ))  -- PWW PWE PSW  		
        /*    or  
			( pop_stratum.evalid in (92101,102101,232101,242101,252001,332101,342001,
                                     362001,422101,442001,502101,542101 ))  -- NE		
            or  
			( pop_stratum.evalid in (172101,182101,192101,292101,392101,262101,272101,552101,
                                     121901,132101,372201,452101,512101  ))  -- CS SE NLS	
            or  
		   ( pop_stratum.evalid in (202001,312101,382101,462101,12201,52101,211901,221901,282101,471901))  -- GP & SC		
            or			  
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
        */  ) 

        
		  
      
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
           case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end ,

          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd),refftgrp.meaning,
      cond.stdorgcd,cond.statecd,cond.unitcd,cond.trtcd1,cond.trtcd2,cond.trtcd3,
                             cond.dstrbcd1,cond.dstrbcd2,cond.dstrbcd3 , refft.typgrpcd
      ) 
    GROUP BY 
    /*statecd,*/
      conusRegion, cube(possibleTypes,standOrigin,ageBin)
	/*harvDstrb,*/
    --possibleTypes,
    --standOrigin,
    --ageBin
    
    ORDER BY 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
    possibleTypes,
    standOrigin,
    ageBin

  ) num 
  
  
  
  join (
    SELECT 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
    coalesce(possibleTypes,'Unknown') as possibleTypes,
    coalesce(standOrigin, 'Unknown') as standOrigin,
    coalesce(ageBin, 'Unknown') as ageBin,
      sum(ESTIMATED_VALUE * EXPNS) ESTIMATE 
    FROM 
      (
        SELECT 
 
            case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end as agebin,
				  
      
      -- FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd) as possibleTypes, 
      
      case when refft.typgrpcd in (180,970) then 'predominantly woodland species, type not known'
		    when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)'
			when refft.typgrpcd <400 then 'predominantly softwood species, type not known'
            else 'predominantly hardwood species, type not known' end as 	possibleTypes,	
			
      	--refftgrp.meaning 	as 	possibleTypes,
		
      case when cond.stdorgcd=1 then 'Planted'
		else 'Natural' end as standOrigin,
		           
      -- to_char(cond.statecd)  statecd, 

      /*case 
      when cond.trtcd1=10 or cond.trtcd2=10 or cond.trtcd3=10 then 'harv/distrb' 
      when cond.dstrbcd1 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd2 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
      when cond.dstrbcd3 in (10,12,20,22,30,32,50,51,52,53,80,90,91,92,93,94,95) then 'harv/distrb' 
            else 'without h/d'
      end  harvDstrb,*/

       case when cond.statecd in(9,10,11,23,24,25,33,34,36,42,44,50,54) then 'Northeast'
            when cond.statecd in(17,18,19,29,39) then 'Central States'
            when cond.statecd in(20,31,38,46) then 'Great Plains'
            when cond.statecd in(26,27,55) then 'Northern Lake States'
            when ( cond.statecd in(40,48) and cond.unitcd in(3,4,5,6,7) ) then 'Great Plains'
            when cond.statecd in(1,5,21,22,28,40,47,48)  then 'South Central'
            when cond.statecd in(12,13,37,45,51)  then 'Southeast'
            when cond.statecd in(16,30)  then 'Rocky Mountain North'
            when cond.statecd in(4,8,32,35,49,56)  then 'Rocky Mountain South'
            when cond.statecd in(6)  then 'Pacific Southwest'
            when ( cond.statecd in(41,53) and cond.unitcd in(0,1,2,5,6,7) ) then 'Pacific Northwest Westside'
            when ( cond.statecd in(41,53) and cond.unitcd in(3,4,8,9) ) then 'Pacific Northwest Eastside'
            else 'not located' end as conusRegion ,

        pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ESTIMATED_VALUE 
		  
         FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN ) 
		  join (select  unique  plt_cn, condid, prev_plt_cn, prevcond, SUBPTYP
               from  FS_FIADB.SUBP_COND_CHNG_MTRX ) sccm on (sccm.plt_cn = POP_PLOT_STRATUM_ASSGN.PLT_CN)
          JOIN FS_FIADB.PLOT PLOT ON ( POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN   ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
		  JOIN FS_FIADB.PLOT PPLOT ON (PLOT.PREV_PLT_CN = PPLOT.CN) 
          JOIN FS_FIADB.COND PCOND ON (PLOT.PREV_PLT_CN = PCOND.PLT_CN) 
          JOIN FS_FIADB.COND COND ON (PLOT.CN = COND.PLT_CN) 
 	  
       JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
      JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
	   	   
		
      
       WHERE 
		         --TREE.STATUSCD = 1 
		  sccm.condid = COND.CONDID 
          AND sccm.plt_cn = COND.PLT_CN 
          AND PCOND.CONDID = sccm.prevcond 
          AND PCOND.PLT_CN = sccm.prev_plt_cn 
		  
           and ( (COND.PROP_BASIS != 'MACR' and  sccm.SUBPTYP = 1 ) or
		        (COND.PROP_BASIS='MACR' and  sccm.SUBPTYP = 3 ) ) 
		  
		  and COND.CONDPROP_UNADJ  = pCOND.CONDPROP_UNADJ 
          and COND.COND_STATUS_CD = 1 
		  and pCOND.COND_STATUS_CD = 1 
 		  AND COND.CONDPROP_UNADJ IS NOT NULL 

 		  
		  
 		  --and pop_stratum.evalid in (331901)
      /* conus44 and the 4 split states */
	  
   AND (
     		( pop_stratum.evalid in (161901,301901,41901,81901,321901,351901,491901,561801)) -- RMN RMS 		
           or  
			( pop_stratum.evalid in (61901,411901,531901 ))  -- PWW PWE PSW  		
        /*    or  
			( pop_stratum.evalid in (92101,102101,232101,242101,252001,332101,342001,
                                     362001,422101,442001,502101,542101 ))  -- NE		
            or  
			( pop_stratum.evalid in (172101,182101,192101,292101,392101,262101,272101,552101,
                                     121901,132101,372201,452101,512101  ))  -- CS SE NLS	
            or  
		   ( pop_stratum.evalid in (202001,312101,382101,462101,12201,52101,211901,221901,282101,471901))  -- GP & SC		
            or			  
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
        */  ) 

        
      
      
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          case when (cond.stdage between 0 and 20) then '0-20 years'
                when (cond.stdage between 21 and 40) then '21-40 years'
                when (cond.stdage between 41 and 60) then '41-60 years'
                when (cond.stdage between 61 and 80) then '61-80 years'
                when (cond.stdage between 81 and 100) then '81-100 years'
                when (cond.stdage between 101 and 998) then '100+ years'
                  else 'w/o age - row not selectable' end ,

          FS_FIADB.EVALIDATORFUNCTIONS.fortypgrpcdLabel(cond.fortypcd),
      cond.stdorgcd,cond.statecd,cond.unitcd,cond.trtcd1,cond.trtcd2,cond.trtcd3,refftgrp.meaning,
                             cond.dstrbcd1,cond.dstrbcd2,cond.dstrbcd3 , refft.typgrpcd
      ) 
    GROUP BY 
    /*statecd,*/
    conusRegion, cube(possibleTypes,standOrigin,ageBin)
	/*harvDstrb,*/
    --possibleTypes,
    --standOrigin,
    --ageBin

    ORDER BY 
    /*statecd,*/
    conusRegion,
	/*harvDstrb,*/
    possibleTypes,
    standOrigin,
    ageBin

  ) den ON num.conusRegion = den.conusRegion 
  AND num.possibleTypes = den.possibleTypes
  AND num.standOrigin = den.standOrigin
  AND num.ageBin = den.ageBin
  /*AND num.conusRegion = den.conusRegion
  AND num.standOrigin = den.standOrigin*/






ORDER BY 
    conusRegion,
    possibleTypes,
    standOrigin,
    ageBin